/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.WingedBird;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public abstract class BipedBirdModel<T extends class_1297 & NotGrounded>
extends class_583<T> {
    public final class_630 head;
    public final class_630 jaw;
    public final class_630 neck;
    public final class_630 body;
    public final class_630 rightLeg;
    public final class_630 leftLeg;
    public final class_630 rightWing;
    public final class_630 leftWing;
    public final class_630 rightTailFeather;
    public final class_630 middleTailFeather;
    public final class_630 leftTailFeather;

    public BipedBirdModel(class_630 root) {
        this.head = root.method_32086("head");
        this.jaw = this.head.method_32086("jaw");
        this.neck = this.head.method_32086("neck");
        this.body = root.method_32086("body");
        this.rightLeg = root.method_32086("right_leg");
        this.leftLeg = root.method_32086("left_leg");
        this.rightWing = this.body.method_32086("right_wing");
        this.leftWing = this.body.method_32086("left_wing");
        this.rightTailFeather = root.method_32086("right_tail_feather");
        this.middleTailFeather = root.method_32086("middle_tail_feather");
        this.leftTailFeather = root.method_32086("left_tail_feather");
    }

    public static class_5607 createBodyLayer(class_5605 cube) {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5610 head = partDefinition.method_32117("head", class_5606.method_32108().method_32101(0, 13).method_32099(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 8.0f, cube, 0.5f, 0.5f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)-4.0f));
        head.method_32117("jaw", class_5606.method_32108().method_32101(24, 13).method_32099(-2.0f, -1.0f, -6.0f, 4.0f, 1.0f, 8.0f, new class_5605(-0.1f), 0.5f, 0.5f), class_5603.field_27701);
        head.method_32117("neck", class_5606.method_32108().method_32101(22, 0).method_32099(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, cube, 0.5f, 0.5f), class_5603.field_27701);
        class_5610 body = partDefinition.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32099(-3.0f, -3.0f, 0.0f, 6.0f, 8.0f, 5.0f, cube, 0.5f, 0.5f), class_5603.method_32091((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partDefinition.method_32117("right_leg", class_5606.method_32108().method_32101(54, 21).method_32099(-0.99f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, cube, 0.5f, 0.5f), class_5603.method_32090((float)-2.0f, (float)16.0f, (float)1.0f));
        partDefinition.method_32117("left_leg", class_5606.method_32108().method_32101(46, 21).method_32099(-1.01f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, cube, 0.5f, 0.5f), class_5603.method_32090((float)2.0f, (float)16.0f, (float)1.0f));
        body.method_32117("right_wing", class_5606.method_32108().method_32101(40, 0).method_32099(-1.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, cube, 0.5f, 0.5f), class_5603.method_32090((float)-3.001f, (float)-3.0f, (float)3.0f));
        body.method_32117("left_wing", class_5606.method_32108().method_32101(30, 0).method_32099(0.0f, 0.0f, -2.0f, 1.0f, 8.0f, 4.0f, cube, 0.5f, 0.5f), class_5603.method_32090((float)3.001f, (float)-3.0f, (float)3.0f));
        partDefinition.method_32117("right_tail_feather", class_5606.method_32108().method_32101(0, 26).method_32099(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new class_5605(-0.3f), 0.5f, 0.5f), class_5603.method_32091((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)-0.375f, (float)0.0f));
        partDefinition.method_32117("middle_tail_feather", class_5606.method_32108().method_32101(14, 26).method_32099(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new class_5605(-0.3f), 0.5f, 0.5f), class_5603.method_32091((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.0f, (float)0.0f));
        partDefinition.method_32117("left_tail_feather", class_5606.method_32108().method_32101(28, 26).method_32099(-1.0f, -5.0f, 5.0f, 2.0f, 1.0f, 5.0f, new class_5605(-0.3f), 0.5f, 0.5f), class_5603.method_32091((float)0.0f, (float)17.5f, (float)1.0f, (float)0.25f, (float)0.375f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)128, (int)64);
    }

    public void method_2819(T bipedBird, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        this.neck.field_3654 = -this.head.field_3654;
        if (!((NotGrounded)bipedBird).isEntityOnGround()) {
            this.rightWing.method_2851(-3.001f, 0.0f, 4.0f);
            this.leftWing.method_2851(3.001f, 0.0f, 4.0f);
            this.leftWing.field_3654 = this.rightWing.field_3654 = -1.5707964f;
            this.leftLeg.field_3654 = this.rightLeg.field_3654 = 0.6f;
            this.rightWing.field_3675 = ageInTicks;
        } else {
            this.rightWing.method_2851(-3.001f, -3.0f, 3.0f);
            this.leftWing.method_2851(3.001f, -3.0f, 3.0f);
            this.rightWing.field_3654 = 0.0f;
            this.leftWing.field_3654 = 0.0f;
            this.rightLeg.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightWing.field_3675 = 0.0f;
        }
        this.leftWing.field_3675 = -this.rightWing.field_3675;
    }

    public float setupWingsAnimation(T bipedBird, float partialTicks) {
        float rotVal = class_3532.method_16439((float)partialTicks, (float)((WingedBird)bipedBird).getPrevWingRotation(), (float)((WingedBird)bipedBird).getWingRotation());
        float destVal = class_3532.method_16439((float)partialTicks, (float)((WingedBird)bipedBird).getPrevWingDestPos(), (float)((WingedBird)bipedBird).getWingDestPos());
        return (class_3532.method_15374((float)(rotVal * 0.225f)) + 1.0f) * destVal;
    }

    public void method_2828(class_4587 poseStack, class_4588 consumer, int packedLight, int packedOverlay, int color) {
        this.head.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
        this.body.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
        this.rightTailFeather.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
        this.middleTailFeather.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
        this.leftTailFeather.method_22699(poseStack, consumer, packedLight, packedOverlay, color);
    }
}

